<?php
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

/**
 * @var $app \Slim\App
 */
return function (\Slim\App $app) {

    $app->get('', function (Request $request, Response $response, $args) use($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->baap();
    });

    $app->get('/', function (Request $request, Response $response, $args) use($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->baap();
    });

    $app->get('listingIndex', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->index();
    })->setName('listingIndex');

    $app->get('listing', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->listing();
    })->setName("listing");

    $app->get('unitAvailabilityIndex', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->unitAvailabilityIndex();
    })->setName('unitAvailabilityIndex');

    $app->get('availability', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->unitAvailability();
    })->setName('availability');

    $app->get('lodgingConfigIndex', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->lodgingConfigIndex();
    })->setName('lodgingConfigIndex');

    $app->get('lodgingConfigContent', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->lodgingConfigContent();
    })->setName('lodgingConfigContent');

    $app->get('lodgingRateIndex', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->lodgingRateIndex();
    })->setName('lodgingRateIndex');

    $app->get('lodgingRateContent', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->lodgingRateContent();
    })->setName('lodgingRateContent');

    $app->get('pushLodgingRateUpdate', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->pushLodgingRateUpdate();
    })->setName('lodgingRateContent');

    $app->get('pushUnitAvailabilityUpdate', function (Request $request, Response $response, $args) use ($app) {
        return (new \App\Controllers\ListingsController($request,$response,$args,$app))->pushUnitAvailabilityUpdate();
    })->setName('pushUnitAvailabilityUpdate');

};